// Background service worker for Chrome extension
chrome.runtime.onInstalled.addListener(() => {
    console.log('Unshared Assistant extension installed');
});

// Handle messages from popup
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'getSettings') {
        chrome.storage.local.get(['settings'], (result) => {
            sendResponse({ settings: result.settings || {} });
        });
        return true; // Keep channel open for async response
    }
});